"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    job_template_id: str,
    description: str,
    job_arn: str = None,
    document_source: str = None,
    document: str = None,
    presigned_url_config: Dict = None,
    job_executions_rollout_config: Dict = None,
    abort_config: Dict = None,
    timeout_config: Dict = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a job template.

    Args:
        job_template_id(str): A unique identifier for the job template. We recommend using a UUID. Alpha-numeric characters, "-", and "_" are valid for use here.
        job_arn(str, optional): The ARN of the job to use as the basis for the job template. Defaults to None.
        document_source(str, optional): An S3 link to the job document to use in the template. Required if you don't specify a value for document.  If the job document resides in an S3 bucket, you must use a placeholder link when specifying the document. The placeholder link is of the following form:  ${aws:iot:s3-presigned-url:https://s3.amazonaws.com/bucket/key}  where bucket is your bucket name and key is the object in the bucket to which you are linking. . Defaults to None.
        document(str, optional): The job document. Required if you don't specify a value for documentSource. Defaults to None.
        description(str): A description of the job document.
        presigned_url_config(Dict, optional): Configuration for pre-signed S3 URLs. Defaults to None.
        job_executions_rollout_config(Dict, optional): Allows you to create a staged rollout of a job. Defaults to None.
        abort_config(Dict, optional): The criteria that determine when and how a job abort takes place. Defaults to None.
        timeout_config(Dict, optional): Specifies the amount of time each device has to finish its execution of the job. A timer is started when the job execution status is set to IN_PROGRESS. If the job execution status is not set to another terminal state before the timer expires, it will be automatically set to TIMED_OUT. Defaults to None.
        tags(List, optional): Metadata that can be used to manage the job template. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.job.template.create(
                ctx, job_template_id=value, description=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.job.template.create job_template_id=value, description=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="create_job_template",
        op_kwargs={
            "jobTemplateId": job_template_id,
            "jobArn": job_arn,
            "documentSource": document_source,
            "document": document,
            "description": description,
            "presignedUrlConfig": presigned_url_config,
            "jobExecutionsRolloutConfig": job_executions_rollout_config,
            "abortConfig": abort_config,
            "timeoutConfig": timeout_config,
            "tags": tags,
        },
    )


async def delete(hub, ctx, job_template_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified job template.

    Args:
        job_template_id(str): The unique identifier of the job template to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.job.template.delete(ctx, job_template_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.job.template.delete job_template_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="delete_job_template",
        op_kwargs={"jobTemplateId": job_template_id},
    )


async def describe(hub, ctx, job_template_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about a job template.

    Args:
        job_template_id(str): The unique identifier of the job template.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.job.template.describe(ctx, job_template_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.job.template.describe job_template_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="describe_job_template",
        op_kwargs={"jobTemplateId": job_template_id},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of job templates.

    Args:
        max_results(int, optional): The maximum number of results to return in the list. Defaults to None.
        next_token(str, optional): The token to use to return the next set of results in the list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.job.template.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.job.template.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="list_job_templates",
        op_kwargs={"maxResults": max_results, "nextToken": next_token},
    )
