"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def cancel(
    hub,
    ctx,
    job_id: str,
    reason_code: str = None,
    comment: str = None,
    force: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Cancels a job.

    Args:
        job_id(str): The unique identifier you assigned to this job when it was created.
        reason_code(str, optional): (Optional)A reason code string that explains why the job was canceled. Defaults to None.
        comment(str, optional): An optional comment string describing why the job was canceled. Defaults to None.
        force(bool, optional): (Optional) If true job executions with status "IN_PROGRESS" and "QUEUED" are canceled, otherwise only job executions with status "QUEUED" are canceled. The default is false. Canceling a job which is "IN_PROGRESS", will cause a device which is executing the job to be unable to update the job execution status. Use caution and ensure that each device executing a job which is canceled is able to recover to a valid state. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.job.init.cancel(ctx, job_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.job.init.cancel job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="cancel_job",
        op_kwargs={
            "jobId": job_id,
            "reasonCode": reason_code,
            "comment": comment,
            "force": force,
        },
    )


async def create(
    hub,
    ctx,
    job_id: str,
    targets: List,
    document_source: str = None,
    document: str = None,
    description: str = None,
    presigned_url_config: Dict = None,
    target_selection: str = None,
    job_executions_rollout_config: Dict = None,
    abort_config: Dict = None,
    timeout_config: Dict = None,
    tags: List = None,
    namespace_id: str = None,
    job_template_arn: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a job.

    Args:
        job_id(str): A job identifier which must be unique for your AWS account. We recommend using a UUID. Alpha-numeric characters, "-" and "_" are valid for use here.
        targets(List): A list of things and thing groups to which the job should be sent.
        document_source(str, optional): An S3 link to the job document. Required if you don't specify a value for document.  If the job document resides in an S3 bucket, you must use a placeholder link when specifying the document. The placeholder link is of the following form:  ${aws:iot:s3-presigned-url:https://s3.amazonaws.com/bucket/key}  where bucket is your bucket name and key is the object in the bucket to which you are linking. . Defaults to None.
        document(str, optional): The job document. Required if you don't specify a value for documentSource. Defaults to None.
        description(str, optional): A short text description of the job. Defaults to None.
        presigned_url_config(Dict, optional): Configuration information for pre-signed S3 URLs. Defaults to None.
        target_selection(str, optional): Specifies whether the job will continue to run (CONTINUOUS), or will be complete after all those things specified as targets have completed the job (SNAPSHOT). If continuous, the job may also be run on a thing when a change is detected in a target. For example, a job will run on a thing when the thing is added to a target group, even after the job was completed by all things originally in the group. Defaults to None.
        job_executions_rollout_config(Dict, optional): Allows you to create a staged rollout of the job. Defaults to None.
        abort_config(Dict, optional): Allows you to create criteria to abort a job. Defaults to None.
        timeout_config(Dict, optional): Specifies the amount of time each device has to finish its execution of the job. The timer is started when the job execution status is set to IN_PROGRESS. If the job execution status is not set to another terminal state before the time expires, it will be automatically set to TIMED_OUT. Defaults to None.
        tags(List, optional): Metadata which can be used to manage the job. Defaults to None.
        namespace_id(str, optional): The namespace used to indicate that a job is a customer-managed job. When you specify a value for this parameter, AWS IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.  $aws/things/THING_NAME/jobs/JOB_ID/notify-namespace-NAMESPACE_ID/   The namespaceId feature is in public preview. . Defaults to None.
        job_template_arn(str, optional): The ARN of the job template used to create the job. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.job.init.create(ctx, job_id=value, targets=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.job.init.create job_id=value, targets=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="create_job",
        op_kwargs={
            "jobId": job_id,
            "targets": targets,
            "documentSource": document_source,
            "document": document,
            "description": description,
            "presignedUrlConfig": presigned_url_config,
            "targetSelection": target_selection,
            "jobExecutionsRolloutConfig": job_executions_rollout_config,
            "abortConfig": abort_config,
            "timeoutConfig": timeout_config,
            "tags": tags,
            "namespaceId": namespace_id,
            "jobTemplateArn": job_template_arn,
        },
    )


async def delete(
    hub, ctx, job_id: str, force: bool = None, namespace_id: str = None
) -> None:
    r"""
    **Autogenerated function**

    Deletes a job and its related job executions. Deleting a job may take time, depending on the number of job executions created for the job and various other factors. While the job is being deleted, the status of the job will be shown as "DELETION_IN_PROGRESS". Attempting to delete or cancel a job whose status is already "DELETION_IN_PROGRESS" will result in an error. Only 10 jobs may have status "DELETION_IN_PROGRESS" at the same time, or a LimitExceededException will occur.

    Args:
        job_id(str): The ID of the job to be deleted. After a job deletion is completed, you may reuse this jobId when you create a new job. However, this is not recommended, and you must ensure that your devices are not using the jobId to refer to the deleted job.
        force(bool, optional): (Optional) When true, you can delete a job which is "IN_PROGRESS". Otherwise, you can only delete a job which is in a terminal state ("COMPLETED" or "CANCELED") or an exception will occur. The default is false.  Deleting a job which is "IN_PROGRESS", will cause a device which is executing the job to be unable to access job information or update the job execution status. Use caution and ensure that each device executing a job which is deleted is able to recover to a valid state. . Defaults to None.
        namespace_id(str, optional): The namespace used to indicate that a job is a customer-managed job. When you specify a value for this parameter, AWS IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.  $aws/things/THING_NAME/jobs/JOB_ID/notify-namespace-NAMESPACE_ID/   The namespaceId feature is in public preview. . Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.job.init.delete(ctx, job_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.job.init.delete job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="delete_job",
        op_kwargs={"jobId": job_id, "force": force, "namespaceId": namespace_id},
    )


async def describe(hub, ctx, job_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes a job.

    Args:
        job_id(str): The unique identifier you assigned to this job when it was created.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.job.init.describe(ctx, job_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.job.init.describe job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="iot", operation="describe_job", op_kwargs={"jobId": job_id}
    )


async def update(
    hub,
    ctx,
    job_id: str,
    description: str = None,
    presigned_url_config: Dict = None,
    job_executions_rollout_config: Dict = None,
    abort_config: Dict = None,
    timeout_config: Dict = None,
    namespace_id: str = None,
) -> None:
    r"""
    **Autogenerated function**

    Updates supported fields of the specified job.

    Args:
        job_id(str): The ID of the job to be updated.
        description(str, optional): A short text description of the job. Defaults to None.
        presigned_url_config(Dict, optional): Configuration information for pre-signed S3 URLs. Defaults to None.
        job_executions_rollout_config(Dict, optional): Allows you to create a staged rollout of the job. Defaults to None.
        abort_config(Dict, optional): Allows you to create criteria to abort a job. Defaults to None.
        timeout_config(Dict, optional): Specifies the amount of time each device has to finish its execution of the job. The timer is started when the job execution status is set to IN_PROGRESS. If the job execution status is not set to another terminal state before the time expires, it will be automatically set to TIMED_OUT. . Defaults to None.
        namespace_id(str, optional): The namespace used to indicate that a job is a customer-managed job. When you specify a value for this parameter, AWS IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.  $aws/things/THING_NAME/jobs/JOB_ID/notify-namespace-NAMESPACE_ID/   The namespaceId feature is in public preview. . Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.job.init.update(ctx, job_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.job.init.update job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="update_job",
        op_kwargs={
            "jobId": job_id,
            "description": description,
            "presignedUrlConfig": presigned_url_config,
            "jobExecutionsRolloutConfig": job_executions_rollout_config,
            "abortConfig": abort_config,
            "timeoutConfig": timeout_config,
            "namespaceId": namespace_id,
        },
    )
