"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def cancel(
    hub,
    ctx,
    job_id: str,
    thing_name: str,
    force: bool = None,
    expected_version: int = None,
    status_details: Dict = None,
) -> None:
    r"""
    **Autogenerated function**

    Cancels the execution of a job for a given thing.

    Args:
        job_id(str): The ID of the job to be canceled.
        thing_name(str): The name of the thing whose execution of the job will be canceled.
        force(bool, optional): (Optional) If true the job execution will be canceled if it has status IN_PROGRESS or QUEUED, otherwise the job execution will be canceled only if it has status QUEUED. If you attempt to cancel a job execution that is IN_PROGRESS, and you do not set force to true, then an InvalidStateTransitionException will be thrown. The default is false. Canceling a job execution which is "IN_PROGRESS", will cause the device to be unable to update the job execution status. Use caution and ensure that the device is able to recover to a valid state. Defaults to None.
        expected_version(int, optional): (Optional) The expected current version of the job execution. Each time you update the job execution, its version is incremented. If the version of the job execution stored in Jobs does not match, the update is rejected with a VersionMismatch error, and an ErrorResponse that contains the current job execution status data is returned. (This makes it unnecessary to perform a separate DescribeJobExecution request in order to obtain the job execution status data.). Defaults to None.
        status_details(Dict, optional): A collection of name/value pairs that describe the status of the job execution. If not specified, the statusDetails are unchanged. You can specify at most 10 name/value pairs. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.job.execution.init.cancel(
                ctx, job_id=value, thing_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.job.execution.init.cancel job_id=value, thing_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="cancel_job_execution",
        op_kwargs={
            "jobId": job_id,
            "thingName": thing_name,
            "force": force,
            "expectedVersion": expected_version,
            "statusDetails": status_details,
        },
    )


async def delete(
    hub,
    ctx,
    job_id: str,
    thing_name: str,
    execution_number: int,
    force: bool = None,
    namespace_id: str = None,
) -> None:
    r"""
    **Autogenerated function**

    Deletes a job execution.

    Args:
        job_id(str): The ID of the job whose execution on a particular device will be deleted.
        thing_name(str): The name of the thing whose job execution will be deleted.
        execution_number(int): The ID of the job execution to be deleted. The executionNumber refers to the execution of a particular job on a particular device. Note that once a job execution is deleted, the executionNumber may be reused by IoT, so be sure you get and use the correct value here.
        force(bool, optional): (Optional) When true, you can delete a job execution which is "IN_PROGRESS". Otherwise, you can only delete a job execution which is in a terminal state ("SUCCEEDED", "FAILED", "REJECTED", "REMOVED" or "CANCELED") or an exception will occur. The default is false.  Deleting a job execution which is "IN_PROGRESS", will cause the device to be unable to access job information or update the job execution status. Use caution and ensure that the device is able to recover to a valid state. . Defaults to None.
        namespace_id(str, optional): The namespace used to indicate that a job is a customer-managed job. When you specify a value for this parameter, AWS IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.  $aws/things/THING_NAME/jobs/JOB_ID/notify-namespace-NAMESPACE_ID/   The namespaceId feature is in public preview. . Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.job.execution.init.delete(
                ctx, job_id=value, thing_name=value, execution_number=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.job.execution.init.delete job_id=value, thing_name=value, execution_number=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="delete_job_execution",
        op_kwargs={
            "jobId": job_id,
            "thingName": thing_name,
            "executionNumber": execution_number,
            "force": force,
            "namespaceId": namespace_id,
        },
    )


async def describe(
    hub, ctx, job_id: str, thing_name: str, execution_number: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Describes a job execution.

    Args:
        job_id(str): The unique identifier you assigned to this job when it was created.
        thing_name(str): The name of the thing on which the job execution is running.
        execution_number(int, optional): A string (consisting of the digits "0" through "9" which is used to specify a particular job execution on a particular device. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.job.execution.init.describe(
                ctx, job_id=value, thing_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.job.execution.init.describe job_id=value, thing_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="describe_job_execution",
        op_kwargs={
            "jobId": job_id,
            "thingName": thing_name,
            "executionNumber": execution_number,
        },
    )
