"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub,
    ctx,
    thing_name: str,
    status: str = None,
    namespace_id: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the job executions for the specified thing.

    Args:
        thing_name(str): The thing name.
        status(str, optional): An optional filter that lets you search for jobs that have the specified status. Defaults to None.
        namespace_id(str, optional): The namespace used to indicate that a job is a customer-managed job. When you specify a value for this parameter, AWS IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.  $aws/things/THING_NAME/jobs/JOB_ID/notify-namespace-NAMESPACE_ID/   The namespaceId feature is in public preview. . Defaults to None.
        max_results(int, optional): The maximum number of results to be returned per request. Defaults to None.
        next_token(str, optional): The token to retrieve the next set of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.job.execution.for_.thing.list(ctx, thing_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.job.execution.for_.thing.list thing_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="list_job_executions_for_thing",
        op_kwargs={
            "thingName": thing_name,
            "status": status,
            "namespaceId": namespace_id,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )
