"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub,
    ctx,
    job_id: str,
    status: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the job executions for a job.

    Args:
        job_id(str): The unique identifier you assigned to this job when it was created.
        status(str, optional): The status of the job. Defaults to None.
        max_results(int, optional): The maximum number of results to be returned per request. Defaults to None.
        next_token(str, optional): The token to retrieve the next set of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.job.execution.for_.job.list(ctx, job_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.job.execution.for_.job.list job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="list_job_executions_for_job",
        op_kwargs={
            "jobId": job_id,
            "status": status,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )
