"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, job_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets a job document.

    Args:
        job_id(str): The unique identifier you assigned to this job when it was created.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.job.document.get(ctx, job_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.job.document.get job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="get_job_document",
        op_kwargs={"jobId": job_id},
    )
