"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def test(
    hub,
    ctx,
    authorizer_name: str,
    token: str = None,
    token_signature: str = None,
    http_context: Dict = None,
    mqtt_context: Dict = None,
    tls_context: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Tests a custom authorization behavior by invoking a specified custom authorizer. Use this to test and debug the custom authorization behavior of devices that connect to the AWS IoT device gateway.

    Args:
        authorizer_name(str): The custom authorizer name.
        token(str, optional): The token returned by your custom authentication service. Defaults to None.
        token_signature(str, optional): The signature made with the token and your custom authentication service's private key. This value must be Base-64-encoded. Defaults to None.
        http_context(Dict, optional): Specifies a test HTTP authorization request. Defaults to None.
        mqtt_context(Dict, optional): Specifies a test MQTT authorization request. Defaults to None.
        tls_context(Dict, optional): Specifies a test TLS authorization request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.invoke_authorizer.test(ctx, authorizer_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.invoke_authorizer.test authorizer_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="test_invoke_authorizer",
        op_kwargs={
            "authorizerName": authorizer_name,
            "token": token,
            "tokenSignature": token_signature,
            "httpContext": http_context,
            "mqttContext": mqtt_context,
            "tlsContext": tls_context,
        },
    )
