"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Gets the indexing configuration.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.indexing_configuration.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.indexing_configuration.get
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="iot", operation="get_indexing_configuration", op_kwargs={}
    )


async def update(
    hub,
    ctx,
    thing_indexing_configuration: Dict = None,
    thing_group_indexing_configuration: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the search configuration.

    Args:
        thing_indexing_configuration(Dict, optional): Thing indexing configuration. Defaults to None.
        thing_group_indexing_configuration(Dict, optional): Thing group indexing configuration. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.indexing_configuration.update(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.indexing_configuration.update
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="update_indexing_configuration",
        op_kwargs={
            "thingIndexingConfiguration": thing_indexing_configuration,
            "thingGroupIndexingConfiguration": thing_group_indexing_configuration,
        },
    )
