"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, index_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes a search index.

    Args:
        index_name(str): The index name.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.index.describe(ctx, index_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.index.describe index_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="describe_index",
        op_kwargs={"indexName": index_name},
    )


async def search(
    hub,
    ctx,
    query_string: str,
    index_name: str = None,
    next_token: str = None,
    max_results: int = None,
    query_version: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    The query search index.

    Args:
        index_name(str, optional): The search index name. Defaults to None.
        query_string(str): The search query string.
        next_token(str, optional): The token used to get the next set of results, or null if there are no additional results. Defaults to None.
        max_results(int, optional): The maximum number of results to return at one time. Defaults to None.
        query_version(str, optional): The query version. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.index.search(ctx, query_string=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.index.search query_string=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="search_index",
        op_kwargs={
            "indexName": index_name,
            "queryString": query_string,
            "nextToken": next_token,
            "maxResults": max_results,
            "queryVersion": query_version,
        },
    )
