"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Describes event configurations.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.event_configuration.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.event_configuration.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="iot", operation="describe_event_configurations", op_kwargs={}
    )


async def update_multiple(hub, ctx, event_configurations: Dict = None) -> Dict:
    r"""
    **Autogenerated function**

    Updates the event configurations.

    Args:
        event_configurations(Dict, optional): The new event configuration values. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.event_configuration.update_multiple(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.event_configuration.update_multiple
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="update_event_configurations",
        op_kwargs={"eventConfigurations": event_configurations},
    )
