"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(
    hub,
    ctx,
    principal: str = None,
    cognito_identity_pool_id: str = None,
    thing_name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets a list of the policies that have an effect on the authorization behavior of the specified device when it connects to the AWS IoT device gateway.

    Args:
        principal(str, optional): The principal. Valid principals are CertificateArn (arn:aws:iot:region:accountId:cert/certificateId), thingGroupArn (arn:aws:iot:region:accountId:thinggroup/groupName) and CognitoId (region:id). Defaults to None.
        cognito_identity_pool_id(str, optional): The Cognito identity pool ID. Defaults to None.
        thing_name(str, optional): The thing name. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.effective_policy.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.effective_policy.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="get_effective_policies",
        op_kwargs={
            "principal": principal,
            "cognitoIdentityPoolId": cognito_identity_pool_id,
            "thingName": thing_name,
        },
    )
