"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    thing_group_name: str,
    query_string: str,
    thing_group_properties: Dict = None,
    index_name: str = None,
    query_version: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a dynamic thing group.

    Args:
        thing_group_name(str): The dynamic thing group name to create.
        thing_group_properties(Dict, optional): The dynamic thing group properties. Defaults to None.
        index_name(str, optional): The dynamic thing group index name.  Currently one index is supported: "AWS_Things". . Defaults to None.
        query_string(str): The dynamic thing group search query string. See Query Syntax for information about query string syntax.
        query_version(str, optional): The dynamic thing group query version.  Currently one query version is supported: "2017-09-30". If not specified, the query version defaults to this value. . Defaults to None.
        tags(List, optional): Metadata which can be used to manage the dynamic thing group. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.dynamic_thing_group.create(
                ctx, thing_group_name=value, query_string=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.dynamic_thing_group.create thing_group_name=value, query_string=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="create_dynamic_thing_group",
        op_kwargs={
            "thingGroupName": thing_group_name,
            "thingGroupProperties": thing_group_properties,
            "indexName": index_name,
            "queryString": query_string,
            "queryVersion": query_version,
            "tags": tags,
        },
    )


async def delete(hub, ctx, thing_group_name: str, expected_version: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a dynamic thing group.

    Args:
        thing_group_name(str): The name of the dynamic thing group to delete.
        expected_version(int, optional): The expected version of the dynamic thing group to delete. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.dynamic_thing_group.delete(ctx, thing_group_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.dynamic_thing_group.delete thing_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="delete_dynamic_thing_group",
        op_kwargs={
            "thingGroupName": thing_group_name,
            "expectedVersion": expected_version,
        },
    )


async def update(
    hub,
    ctx,
    thing_group_name: str,
    thing_group_properties: Dict,
    expected_version: int = None,
    index_name: str = None,
    query_string: str = None,
    query_version: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a dynamic thing group.

    Args:
        thing_group_name(str): The name of the dynamic thing group to update.
        thing_group_properties(Dict): The dynamic thing group properties to update.
        expected_version(int, optional): The expected version of the dynamic thing group to update. Defaults to None.
        index_name(str, optional): The dynamic thing group index to update.  Currently one index is supported: 'AWS_Things'. . Defaults to None.
        query_string(str, optional): The dynamic thing group search query string to update. Defaults to None.
        query_version(str, optional): The dynamic thing group query version to update.  Currently one query version is supported: "2017-09-30". If not specified, the query version defaults to this value. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.dynamic_thing_group.update(
                ctx, thing_group_name=value, thing_group_properties=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.dynamic_thing_group.update thing_group_name=value, thing_group_properties=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="update_dynamic_thing_group",
        op_kwargs={
            "thingGroupName": thing_group_name,
            "thingGroupProperties": thing_group_properties,
            "expectedVersion": expected_version,
            "indexName": index_name,
            "queryString": query_string,
            "queryVersion": query_version,
        },
    )
