"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    domain_configuration_name: str,
    domain_name: str = None,
    server_certificate_arns: List = None,
    validation_certificate_arn: str = None,
    authorizer_config: Dict = None,
    service_type: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a domain configuration.

    Args:
        domain_configuration_name(str): The name of the domain configuration. This value must be unique to a region.
        domain_name(str, optional): The name of the domain. Defaults to None.
        server_certificate_arns(List, optional): The ARNs of the certificates that AWS IoT passes to the device during the TLS handshake. Currently you can specify only one certificate ARN. This value is not required for AWS-managed domains. Defaults to None.
        validation_certificate_arn(str, optional): The certificate used to validate the server certificate and prove domain name ownership. This certificate must be signed by a public certificate authority. This value is not required for AWS-managed domains. Defaults to None.
        authorizer_config(Dict, optional): An object that specifies the authorization service for a domain. Defaults to None.
        service_type(str, optional): The type of service delivered by the endpoint.  AWS IoT Core currently supports only the DATA service type. . Defaults to None.
        tags(List, optional): Metadata which can be used to manage the domain configuration.  For URI Request parameters use format: ...key1=value1&key2=value2... For the CLI command-line parameter use format: &&tags "key1=value1&key2=value2..." For the cli-input-json file use format: "tags": "key1=value1&key2=value2..." . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.domain_configuration.create(
                ctx, domain_configuration_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.domain_configuration.create domain_configuration_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="create_domain_configuration",
        op_kwargs={
            "domainConfigurationName": domain_configuration_name,
            "domainName": domain_name,
            "serverCertificateArns": server_certificate_arns,
            "validationCertificateArn": validation_certificate_arn,
            "authorizerConfig": authorizer_config,
            "serviceType": service_type,
            "tags": tags,
        },
    )


async def delete(hub, ctx, domain_configuration_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified domain configuration.

    Args:
        domain_configuration_name(str): The name of the domain configuration to be deleted.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.domain_configuration.delete(
                ctx, domain_configuration_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.domain_configuration.delete domain_configuration_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="delete_domain_configuration",
        op_kwargs={"domainConfigurationName": domain_configuration_name},
    )


async def describe(hub, ctx, domain_configuration_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets summary information about a domain configuration.

    Args:
        domain_configuration_name(str): The name of the domain configuration.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.domain_configuration.describe(
                ctx, domain_configuration_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.domain_configuration.describe domain_configuration_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="describe_domain_configuration",
        op_kwargs={"domainConfigurationName": domain_configuration_name},
    )


async def list_all(
    hub, ctx, marker: str = None, page_size: int = None, service_type: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets a list of domain configurations for the user. This list is sorted alphabetically by domain configuration name.

    Args:
        marker(str, optional): The marker for the next set of results. Defaults to None.
        page_size(int, optional): The result page size. Defaults to None.
        service_type(str, optional): The type of service delivered by the endpoint. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.domain_configuration.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.domain_configuration.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="list_domain_configurations",
        op_kwargs={
            "marker": marker,
            "pageSize": page_size,
            "serviceType": service_type,
        },
    )


async def update(
    hub,
    ctx,
    domain_configuration_name: str,
    authorizer_config: Dict = None,
    domain_configuration_status: str = None,
    remove_authorizer_config: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates values stored in the domain configuration. Domain configurations for default endpoints can't be updated.

    Args:
        domain_configuration_name(str): The name of the domain configuration to be updated.
        authorizer_config(Dict, optional): An object that specifies the authorization service for a domain. Defaults to None.
        domain_configuration_status(str, optional): The status to which the domain configuration should be updated. Defaults to None.
        remove_authorizer_config(bool, optional): Removes the authorization configuration from a domain. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.domain_configuration.update(
                ctx, domain_configuration_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.domain_configuration.update domain_configuration_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="update_domain_configuration",
        op_kwargs={
            "domainConfigurationName": domain_configuration_name,
            "authorizerConfig": authorizer_config,
            "domainConfigurationStatus": domain_configuration_status,
            "removeAuthorizerConfig": remove_authorizer_config,
        },
    )
