"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    type_: str,
    string_values: List,
    client_request_token: str,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Create a dimension that you can use to limit the scope of a metric used in a security profile for AWS IoT Device Defender. For example, using a TOPIC_FILTER dimension, you can narrow down the scope of the metric only to MQTT topics whose name match the pattern specified in the dimension.

    Args:
        name(str): A unique identifier for the dimension. Choose something that describes the type and value to make it easy to remember what it does.
        type_(str): Specifies the type of dimension. Supported types: TOPIC_FILTER. .
        string_values(List): Specifies the value or list of values for the dimension. For TOPIC_FILTER dimensions, this is a pattern used to match the MQTT topic (for example, "admin/#").
        tags(List, optional): Metadata that can be used to manage the dimension. Defaults to None.
        client_request_token(str): Each dimension must have a unique client request token. If you try to create a new dimension with the same token as a dimension that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.dimension.create(
                ctx, name=value, type_=value, string_values=value, client_request_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.dimension.create name=value, type_=value, string_values=value, client_request_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="create_dimension",
        op_kwargs={
            "name": name,
            "type": type_,
            "stringValues": string_values,
            "tags": tags,
            "clientRequestToken": client_request_token,
        },
    )


async def delete(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Removes the specified dimension from your AWS account.

    Args:
        name(str): The unique identifier for the dimension that you want to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.dimension.delete(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.dimension.delete name=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="iot", operation="delete_dimension", op_kwargs={"name": name}
    )


async def describe(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Provides details about a dimension that is defined in your AWS account.

    Args:
        name(str): The unique identifier for the dimension.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.dimension.describe(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.dimension.describe name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="describe_dimension",
        op_kwargs={"name": name},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    List the set of dimensions that are defined for your AWS account.

    Args:
        next_token(str, optional): The token for the next set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to retrieve at one time. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.dimension.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.dimension.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="list_dimensions",
        op_kwargs={"nextToken": next_token, "maxResults": max_results},
    )


async def update(hub, ctx, name: str, string_values: List) -> Dict:
    r"""
    **Autogenerated function**

    Updates the definition for a dimension. You cannot change the type of a dimension after it is created (you can delete it and recreate it).

    Args:
        name(str): A unique identifier for the dimension. Choose something that describes the type and value to make it easy to remember what it does.
        string_values(List): Specifies the value or list of values for the dimension. For TOPIC_FILTER dimensions, this is a pattern used to match the MQTT topic (for example, "admin/#").

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.dimension.update(ctx, name=value, string_values=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.dimension.update name=value, string_values=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="update_dimension",
        op_kwargs={"name": name, "stringValues": string_values},
    )
