"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def cancel(hub, ctx, task_id: str) -> Dict:
    r"""
    **Autogenerated function**

     Cancels a Device Defender ML Detect mitigation action.

    Args:
        task_id(str):  The unique identifier of the task. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.detect_mitigation_action.task.cancel(ctx, task_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.detect_mitigation_action.task.cancel task_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="cancel_detect_mitigation_actions_task",
        op_kwargs={"taskId": task_id},
    )


async def describe(hub, ctx, task_id: str) -> Dict:
    r"""
    **Autogenerated function**

     Gets information about a Device Defender ML Detect mitigation action.

    Args:
        task_id(str):  The unique identifier of the task. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.detect_mitigation_action.task.describe(ctx, task_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.detect_mitigation_action.task.describe task_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="describe_detect_mitigation_actions_task",
        op_kwargs={"taskId": task_id},
    )


async def list_all(
    hub,
    ctx,
    start_time: str,
    end_time: str,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     List of Device Defender ML Detect mitigation actions tasks.

    Args:
        max_results(int, optional): The maximum number of results to return at one time. The default is 25. Defaults to None.
        next_token(str, optional):  The token for the next set of results. . Defaults to None.
        start_time(str):  A filter to limit results to those found after the specified time. You must specify either the startTime and endTime or the taskId, but not both. .
        end_time(str):  The end of the time period for which ML Detect mitigation actions tasks are returned. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.detect_mitigation_action.task.list_all(
                ctx, start_time=value, end_time=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.detect_mitigation_action.task.list_all start_time=value, end_time=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="list_detect_mitigation_actions_tasks",
        op_kwargs={
            "maxResults": max_results,
            "nextToken": next_token,
            "startTime": start_time,
            "endTime": end_time,
        },
    )


async def start(
    hub,
    ctx,
    task_id: str,
    target: Dict,
    actions: List,
    client_request_token: str,
    violation_event_occurrence_range: Dict = None,
    include_only_active_violations: bool = None,
    include_suppressed_alerts: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Starts a Device Defender ML Detect mitigation actions task.

    Args:
        task_id(str):  The unique identifier of the task. .
        target(Dict):  Specifies the ML Detect findings to which the mitigation actions are applied. .
        actions(List):  The actions to be performed when a device has unexpected behavior. .
        violation_event_occurrence_range(Dict, optional):  Specifies the time period of which violation events occurred between. . Defaults to None.
        include_only_active_violations(bool, optional):  Specifies to list only active violations. . Defaults to None.
        include_suppressed_alerts(bool, optional):  Specifies to include suppressed alerts. . Defaults to None.
        client_request_token(str):  Each mitigation action task must have a unique client request token. If you try to create a new task with the same token as a task that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.detect_mitigation_action.task.start(
                ctx, task_id=value, target=value, actions=value, client_request_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.detect_mitigation_action.task.start task_id=value, target=value, actions=value, client_request_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="start_detect_mitigation_actions_task",
        op_kwargs={
            "taskId": task_id,
            "target": target,
            "actions": actions,
            "violationEventOccurrenceRange": violation_event_occurrence_range,
            "includeOnlyActiveViolations": include_only_active_violations,
            "includeSuppressedAlerts": include_suppressed_alerts,
            "clientRequestToken": client_request_token,
        },
    )
