"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    task_id: str = None,
    violation_id: str = None,
    thing_name: str = None,
    start_time: str = None,
    end_time: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Lists mitigation actions executions for a Device Defender ML Detect Security Profile.

    Args:
        task_id(str, optional):  The unique identifier of the task. . Defaults to None.
        violation_id(str, optional):  The unique identifier of the violation. . Defaults to None.
        thing_name(str, optional):  The name of the thing whose mitigation actions are listed. . Defaults to None.
        start_time(str, optional):  A filter to limit results to those found after the specified time. You must specify either the startTime and endTime or the taskId, but not both. . Defaults to None.
        end_time(str, optional):  The end of the time period for which ML Detect mitigation actions executions are returned. . Defaults to None.
        max_results(int, optional):  The maximum number of results to return at one time. The default is 25. . Defaults to None.
        next_token(str, optional):  The token for the next set of results. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.detect_mitigation_action.execution.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.detect_mitigation_action.execution.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="list_detect_mitigation_actions_executions",
        op_kwargs={
            "taskId": task_id,
            "violationId": violation_id,
            "thingName": thing_name,
            "startTime": start_time,
            "endTime": end_time,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )
