"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


__func_alias__ = {"set_": "set"}


async def set_(hub, ctx, policy_name: str, policy_version_id: str) -> None:
    r"""
    **Autogenerated function**

    Sets the specified version of the specified policy as the policy's default (operative) version. This action affects all certificates to which the policy is attached. To list the principals the policy is attached to, use the ListPrincipalPolicy API.

    Args:
        policy_name(str): The policy name.
        policy_version_id(str): The policy version ID.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.default.policy_version.set(
                ctx, policy_name=value, policy_version_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.default.policy_version.set policy_name=value, policy_version_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="set_default_policy_version",
        op_kwargs={"policyName": policy_name, "policyVersionId": policy_version_id},
    )
