"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"set_": "set"}


async def clear(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Clears the default authorizer.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.default.authorizer.clear(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.default.authorizer.clear
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="iot", operation="clear_default_authorizer", op_kwargs={}
    )


async def describe(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Describes the default authorizer.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.default.authorizer.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.default.authorizer.describe
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="iot", operation="describe_default_authorizer", op_kwargs={}
    )


async def set_(hub, ctx, authorizer_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Sets the default authorizer. This will be used if a websocket connection is made without specifying an authorizer.

    Args:
        authorizer_name(str): The authorizer name.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.default.authorizer.set(ctx, authorizer_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.default.authorizer.set authorizer_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="set_default_authorizer",
        op_kwargs={"authorizerName": authorizer_name},
    )
