"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    metric_name: str,
    metric_type: str,
    client_request_token: str,
    display_name: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Use this API to define a Custom Metric published by your devices to Device Defender.

    Args:
        metric_name(str):  The name of the custom metric. This will be used in the metric report submitted from the device/thing. Shouldn't begin with aws:. Cannot be updated once defined.
        display_name(str, optional):  Field represents a friendly name in the console for the custom metric; it doesn't have to be unique. Don't use this name as the metric identifier in the device metric report. Can be updated once defined. Defaults to None.
        metric_type(str):  The type of the custom metric. Types include string-list, ip-address-list, number-list, and number. .
        tags(List, optional):  Metadata that can be used to manage the custom metric. . Defaults to None.
        client_request_token(str): Each custom metric must have a unique client request token. If you try to create a new custom metric that already exists with a different token, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.custom_metric.create(
                ctx, metric_name=value, metric_type=value, client_request_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.custom_metric.create metric_name=value, metric_type=value, client_request_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="create_custom_metric",
        op_kwargs={
            "metricName": metric_name,
            "displayName": display_name,
            "metricType": metric_type,
            "tags": tags,
            "clientRequestToken": client_request_token,
        },
    )


async def delete(hub, ctx, metric_name: str) -> Dict:
    r"""
    **Autogenerated function**

     Before you can delete a custom metric, you must first remove the custom metric from all security profiles it's a part of. The security profile associated with the custom metric can be found using the ListSecurityProfiles API with metricName set to your custom metric name.   Deletes a Device Defender detect custom metric.

    Args:
        metric_name(str):  The name of the custom metric. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.custom_metric.delete(ctx, metric_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.custom_metric.delete metric_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="delete_custom_metric",
        op_kwargs={"metricName": metric_name},
    )


async def describe(hub, ctx, metric_name: str) -> Dict:
    r"""
    **Autogenerated function**

     Gets information about a Device Defender detect custom metric.

    Args:
        metric_name(str):  The name of the custom metric. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.custom_metric.describe(ctx, metric_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.custom_metric.describe metric_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="describe_custom_metric",
        op_kwargs={"metricName": metric_name},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

     Lists your Device Defender detect custom metrics.

    Args:
        next_token(str, optional):  The token for the next set of results. . Defaults to None.
        max_results(int, optional):  The maximum number of results to return at one time. The default is 25. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.custom_metric.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.custom_metric.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="list_custom_metrics",
        op_kwargs={"nextToken": next_token, "maxResults": max_results},
    )


async def update(hub, ctx, metric_name: str, display_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Updates a Device Defender detect custom metric.

    Args:
        metric_name(str):  The name of the custom metric. Cannot be updated. .
        display_name(str):  Field represents a friendly name in the console for the custom metric, it doesn't have to be unique. Don't use this name as the metric identifier in the device metric report. Can be updated. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.custom_metric.update(
                ctx, metric_name=value, display_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.custom_metric.update metric_name=value, display_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="update_custom_metric",
        op_kwargs={"metricName": metric_name, "displayName": display_name},
    )
