"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def register(hub, ctx, certificate_pem: str, status: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Register a certificate that does not have a certificate authority (CA).

    Args:
        certificate_pem(str): The certificate data, in PEM format.
        status(str, optional): The status of the register certificate request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.certificate.without_ca.register(ctx, certificate_pem=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.certificate.without_ca.register certificate_pem=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="register_certificate_without_ca",
        op_kwargs={"certificatePem": certificate_pem, "status": status},
    )
