"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def accept(hub, ctx, certificate_id: str, set_as_active: bool = None) -> None:
    r"""
    **Autogenerated function**

    Accepts a pending certificate transfer. The default state of the certificate is INACTIVE. To check for pending certificate transfers, call ListCertificates to enumerate your certificates.

    Args:
        certificate_id(str): The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.).
        set_as_active(bool, optional): Specifies whether the certificate is active. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.certificate.transfer.accept(ctx, certificate_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.certificate.transfer.accept certificate_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="accept_certificate_transfer",
        op_kwargs={"certificateId": certificate_id, "setAsActive": set_as_active},
    )


async def cancel(hub, ctx, certificate_id: str) -> None:
    r"""
    **Autogenerated function**

    Cancels a pending transfer for the specified certificate.  Note Only the transfer source account can use this operation to cancel a transfer. (Transfer destinations can use RejectCertificateTransfer instead.) After transfer, AWS IoT returns the certificate to the source account in the INACTIVE state. After the destination account has accepted the transfer, the transfer cannot be cancelled. After a certificate transfer is cancelled, the status of the certificate changes from PENDING_TRANSFER to INACTIVE.

    Args:
        certificate_id(str): The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.).
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.certificate.transfer.cancel(ctx, certificate_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.certificate.transfer.cancel certificate_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="cancel_certificate_transfer",
        op_kwargs={"certificateId": certificate_id},
    )


async def reject(hub, ctx, certificate_id: str, reject_reason: str = None) -> None:
    r"""
    **Autogenerated function**

    Rejects a pending certificate transfer. After AWS IoT rejects a certificate transfer, the certificate status changes from PENDING_TRANSFER to INACTIVE. To check for pending certificate transfers, call ListCertificates to enumerate your certificates. This operation can only be called by the transfer destination. After it is called, the certificate will be returned to the source's account in the INACTIVE state.

    Args:
        certificate_id(str): The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.).
        reject_reason(str, optional): The reason the certificate transfer was rejected. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.certificate.transfer.reject(ctx, certificate_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.certificate.transfer.reject certificate_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="reject_certificate_transfer",
        op_kwargs={"certificateId": certificate_id, "rejectReason": reject_reason},
    )
