"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub,
    ctx,
    ca_certificate_id: str,
    page_size: int = None,
    marker: str = None,
    ascending_order: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    List the device certificates signed by the specified CA certificate.

    Args:
        ca_certificate_id(str): The ID of the CA certificate. This operation will list all registered device certificate that were signed by this CA certificate.
        page_size(int, optional): The result page size. Defaults to None.
        marker(str, optional): The marker for the next set of results. Defaults to None.
        ascending_order(bool, optional): Specifies the order for results. If True, the results are returned in ascending order, based on the creation date. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.certificate.by_ca.list(ctx, ca_certificate_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.certificate.by_ca.list ca_certificate_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="list_certificates_by_ca",
        op_kwargs={
            "caCertificateId": ca_certificate_id,
            "pageSize": page_size,
            "marker": marker,
            "ascendingOrder": ascending_order,
        },
    )
