"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub,
    ctx,
    query_string: str,
    index_name: str = None,
    aggregation_field: str = None,
    query_version: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the approximate count of unique values that match the query.

    Args:
        index_name(str, optional): The name of the index to search. Defaults to None.
        query_string(str): The search query.
        aggregation_field(str, optional): The field to aggregate. Defaults to None.
        query_version(str, optional): The query version. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.cardinality.get(ctx, query_string=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.cardinality.get query_string=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="get_cardinality",
        op_kwargs={
            "indexName": index_name,
            "queryString": query_string,
            "aggregationField": aggregation_field,
            "queryVersion": query_version,
        },
    )
