"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(hub, ctx, certificate_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a registered CA certificate.

    Args:
        certificate_id(str): The ID of the certificate to delete. (The last part of the certificate ARN contains the certificate ID.).

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.ca.certificate.delete(ctx, certificate_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.ca.certificate.delete certificate_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="delete_ca_certificate",
        op_kwargs={"certificateId": certificate_id},
    )


async def describe(hub, ctx, certificate_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes a registered CA certificate.

    Args:
        certificate_id(str): The CA certificate identifier.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.ca.certificate.describe(ctx, certificate_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.ca.certificate.describe certificate_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="describe_ca_certificate",
        op_kwargs={"certificateId": certificate_id},
    )


async def list_all(
    hub, ctx, page_size: int = None, marker: str = None, ascending_order: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the CA certificates registered for your AWS account. The results are paginated with a default page size of 25. You can use the returned marker to retrieve additional results.

    Args:
        page_size(int, optional): The result page size. Defaults to None.
        marker(str, optional): The marker for the next set of results. Defaults to None.
        ascending_order(bool, optional): Determines the order of the results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.ca.certificate.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.ca.certificate.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="list_ca_certificates",
        op_kwargs={
            "pageSize": page_size,
            "marker": marker,
            "ascendingOrder": ascending_order,
        },
    )


async def register(
    hub,
    ctx,
    ca_certificate: str,
    verification_certificate: str,
    set_as_active: bool = None,
    allow_auto_registration: bool = None,
    registration_config: Dict = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Registers a CA certificate with AWS IoT. This CA certificate can then be used to sign device certificates, which can be then registered with AWS IoT. You can register up to 10 CA certificates per AWS account that have the same subject field. This enables you to have up to 10 certificate authorities sign your device certificates. If you have more than one CA certificate registered, make sure you pass the CA certificate when you register your device certificates with the RegisterCertificate API.

    Args:
        ca_certificate(str): The CA certificate.
        verification_certificate(str): The private key verification certificate.
        set_as_active(bool, optional): A boolean value that specifies if the CA certificate is set to active. Defaults to None.
        allow_auto_registration(bool, optional): Allows this CA certificate to be used for auto registration of device certificates. Defaults to None.
        registration_config(Dict, optional): Information about the registration configuration. Defaults to None.
        tags(List, optional): Metadata which can be used to manage the CA certificate.  For URI Request parameters use format: ...key1=value1&key2=value2... For the CLI command-line parameter use format: &&tags "key1=value1&key2=value2..." For the cli-input-json file use format: "tags": "key1=value1&key2=value2..." . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.ca.certificate.register(
                ctx, ca_certificate=value, verification_certificate=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.ca.certificate.register ca_certificate=value, verification_certificate=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="register_ca_certificate",
        op_kwargs={
            "caCertificate": ca_certificate,
            "verificationCertificate": verification_certificate,
            "setAsActive": set_as_active,
            "allowAutoRegistration": allow_auto_registration,
            "registrationConfig": registration_config,
            "tags": tags,
        },
    )


async def update(
    hub,
    ctx,
    certificate_id: str,
    new_status: str = None,
    new_auto_registration_status: str = None,
    registration_config: Dict = None,
    remove_auto_registration: bool = None,
) -> None:
    r"""
    **Autogenerated function**

    Updates a registered CA certificate.

    Args:
        certificate_id(str): The CA certificate identifier.
        new_status(str, optional): The updated status of the CA certificate.  Note: The status value REGISTER_INACTIVE is deprecated and should not be used. Defaults to None.
        new_auto_registration_status(str, optional): The new value for the auto registration status. Valid values are: "ENABLE" or "DISABLE". Defaults to None.
        registration_config(Dict, optional): Information about the registration configuration. Defaults to None.
        remove_auto_registration(bool, optional): If true, removes auto registration. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.ca.certificate.update(ctx, certificate_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.ca.certificate.update certificate_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="update_ca_certificate",
        op_kwargs={
            "certificateId": certificate_id,
            "newStatus": new_status,
            "newAutoRegistrationStatus": new_auto_registration_status,
            "registrationConfig": registration_config,
            "removeAutoRegistration": remove_auto_registration,
        },
    )
