"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    billing_group_name: str,
    billing_group_properties: Dict = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a billing group.

    Args:
        billing_group_name(str): The name you wish to give to the billing group.
        billing_group_properties(Dict, optional): The properties of the billing group. Defaults to None.
        tags(List, optional): Metadata which can be used to manage the billing group. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.billing_group.create(ctx, billing_group_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.billing_group.create billing_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="create_billing_group",
        op_kwargs={
            "billingGroupName": billing_group_name,
            "billingGroupProperties": billing_group_properties,
            "tags": tags,
        },
    )


async def delete(
    hub, ctx, billing_group_name: str, expected_version: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the billing group.

    Args:
        billing_group_name(str): The name of the billing group.
        expected_version(int, optional): The expected version of the billing group. If the version of the billing group does not match the expected version specified in the request, the DeleteBillingGroup request is rejected with a VersionConflictException. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.billing_group.delete(ctx, billing_group_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.billing_group.delete billing_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="delete_billing_group",
        op_kwargs={
            "billingGroupName": billing_group_name,
            "expectedVersion": expected_version,
        },
    )


async def describe(hub, ctx, billing_group_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about a billing group.

    Args:
        billing_group_name(str): The name of the billing group.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.billing_group.describe(ctx, billing_group_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.billing_group.describe billing_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="describe_billing_group",
        op_kwargs={"billingGroupName": billing_group_name},
    )


async def list_all(
    hub,
    ctx,
    next_token: str = None,
    max_results: int = None,
    name_prefix_filter: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the billing groups you have created.

    Args:
        next_token(str, optional): To retrieve the next set of results, the nextToken value from a previous response; otherwise null to receive the first set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return per request. Defaults to None.
        name_prefix_filter(str, optional): Limit the results to billing groups whose names have the given prefix. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.billing_group.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.billing_group.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="list_billing_groups",
        op_kwargs={
            "nextToken": next_token,
            "maxResults": max_results,
            "namePrefixFilter": name_prefix_filter,
        },
    )


async def update(
    hub,
    ctx,
    billing_group_name: str,
    billing_group_properties: Dict,
    expected_version: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates information about the billing group.

    Args:
        billing_group_name(str): The name of the billing group.
        billing_group_properties(Dict): The properties of the billing group.
        expected_version(int, optional): The expected version of the billing group. If the version of the billing group does not match the expected version specified in the request, the UpdateBillingGroup request is rejected with a VersionConflictException. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.billing_group.update(
                ctx, billing_group_name=value, billing_group_properties=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.billing_group.update billing_group_name=value, billing_group_properties=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="update_billing_group",
        op_kwargs={
            "billingGroupName": billing_group_name,
            "billingGroupProperties": billing_group_properties,
            "expectedVersion": expected_version,
        },
    )
