"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(
    hub,
    ctx,
    security_profile_name: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Returns a Device Defender's ML Detect Security Profile training model's status.

    Args:
        security_profile_name(str, optional):  The name of the security profile. . Defaults to None.
        max_results(int, optional):  The maximum number of results to return at one time. The default is 25. . Defaults to None.
        next_token(str, optional):  The token for the next set of results. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.behavior_model_training_summary.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.behavior_model_training_summary.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="get_behavior_model_training_summaries",
        op_kwargs={
            "securityProfileName": security_profile_name,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )
