"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def test(
    hub,
    ctx,
    auth_infos: List,
    principal: str = None,
    cognito_identity_pool_id: str = None,
    client_id: str = None,
    policy_names_to_add: List = None,
    policy_names_to_skip: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Tests if a specified principal is authorized to perform an AWS IoT action on a specified resource. Use this to test and debug the authorization behavior of devices that connect to the AWS IoT device gateway.

    Args:
        principal(str, optional): The principal. Valid principals are CertificateArn (arn:aws:iot:region:accountId:cert/certificateId), thingGroupArn (arn:aws:iot:region:accountId:thinggroup/groupName) and CognitoId (region:id). Defaults to None.
        cognito_identity_pool_id(str, optional): The Cognito identity pool ID. Defaults to None.
        auth_infos(List): A list of authorization info objects. Simulating authorization will create a response for each authInfo object in the list.
        client_id(str, optional): The MQTT client ID. Defaults to None.
        policy_names_to_add(List, optional): When testing custom authorization, the policies specified here are treated as if they are attached to the principal being authorized. Defaults to None.
        policy_names_to_skip(List, optional): When testing custom authorization, the policies specified here are treated as if they are not attached to the principal being authorized. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.authorization.test(ctx, auth_infos=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.authorization.test auth_infos=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="test_authorization",
        op_kwargs={
            "principal": principal,
            "cognitoIdentityPoolId": cognito_identity_pool_id,
            "authInfos": auth_infos,
            "clientId": client_id,
            "policyNamesToAdd": policy_names_to_add,
            "policyNamesToSkip": policy_names_to_skip,
        },
    )
