"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def cancel(hub, ctx, task_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Cancels an audit that is in progress. The audit can be either scheduled or on demand. If the audit isn't in progress, an "InvalidRequestException" occurs.

    Args:
        task_id(str): The ID of the audit you want to cancel. You can only cancel an audit that is "IN_PROGRESS".

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.audit.task.cancel(ctx, task_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.audit.task.cancel task_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="cancel_audit_task",
        op_kwargs={"taskId": task_id},
    )


async def describe(hub, ctx, task_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about a Device Defender audit.

    Args:
        task_id(str): The ID of the audit whose information you want to get.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.audit.task.describe(ctx, task_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.audit.task.describe task_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="describe_audit_task",
        op_kwargs={"taskId": task_id},
    )


async def list_all(
    hub,
    ctx,
    start_time: str,
    end_time: str,
    task_type: str = None,
    task_status: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the Device Defender audits that have been performed during a given time period.

    Args:
        start_time(str): The beginning of the time period. Audit information is retained for a limited time (90 days). Requesting a start time prior to what is retained results in an "InvalidRequestException".
        end_time(str): The end of the time period.
        task_type(str, optional): A filter to limit the output to the specified type of audit: can be one of "ON_DEMAND_AUDIT_TASK" or "SCHEDULED__AUDIT_TASK". Defaults to None.
        task_status(str, optional): A filter to limit the output to audits with the specified completion status: can be one of "IN_PROGRESS", "COMPLETED", "FAILED", or "CANCELED". Defaults to None.
        next_token(str, optional): The token for the next set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return at one time. The default is 25. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.audit.task.list_all(ctx, start_time=value, end_time=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.audit.task.list_all start_time=value, end_time=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="list_audit_tasks",
        op_kwargs={
            "startTime": start_time,
            "endTime": end_time,
            "taskType": task_type,
            "taskStatus": task_status,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
