"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    check_name: str,
    resource_identifier: Dict,
    client_request_token: str,
    expiration_date: str = None,
    suppress_indefinitely: bool = None,
    description: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Creates a Device Defender audit suppression.

    Args:
        check_name(str): An audit check name. Checks must be enabled for your account. (Use DescribeAccountAuditConfiguration to see the list of all checks, including those that are enabled or use UpdateAccountAuditConfiguration to select which checks are enabled.).
        resource_identifier(Dict): Information that identifies the noncompliant resource.
        expiration_date(str, optional):  The epoch timestamp in seconds at which this suppression expires. . Defaults to None.
        suppress_indefinitely(bool, optional):  Indicates whether a suppression should exist indefinitely or not. . Defaults to None.
        description(str, optional):  The description of the audit suppression. . Defaults to None.
        client_request_token(str):  The epoch timestamp in seconds at which this suppression expires. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.audit.suppression.create(
                ctx, check_name=value, resource_identifier=value, client_request_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.audit.suppression.create check_name=value, resource_identifier=value, client_request_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="create_audit_suppression",
        op_kwargs={
            "checkName": check_name,
            "resourceIdentifier": resource_identifier,
            "expirationDate": expiration_date,
            "suppressIndefinitely": suppress_indefinitely,
            "description": description,
            "clientRequestToken": client_request_token,
        },
    )


async def delete(hub, ctx, check_name: str, resource_identifier: Dict) -> Dict:
    r"""
    **Autogenerated function**

     Deletes a Device Defender audit suppression.

    Args:
        check_name(str): An audit check name. Checks must be enabled for your account. (Use DescribeAccountAuditConfiguration to see the list of all checks, including those that are enabled or use UpdateAccountAuditConfiguration to select which checks are enabled.).
        resource_identifier(Dict): Information that identifies the noncompliant resource.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.audit.suppression.delete(
                ctx, check_name=value, resource_identifier=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.audit.suppression.delete check_name=value, resource_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="delete_audit_suppression",
        op_kwargs={"checkName": check_name, "resourceIdentifier": resource_identifier},
    )


async def describe(hub, ctx, check_name: str, resource_identifier: Dict) -> Dict:
    r"""
    **Autogenerated function**

     Gets information about a Device Defender audit suppression.

    Args:
        check_name(str): An audit check name. Checks must be enabled for your account. (Use DescribeAccountAuditConfiguration to see the list of all checks, including those that are enabled or use UpdateAccountAuditConfiguration to select which checks are enabled.).
        resource_identifier(Dict): Information that identifies the noncompliant resource.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.audit.suppression.describe(
                ctx, check_name=value, resource_identifier=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.audit.suppression.describe check_name=value, resource_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="describe_audit_suppression",
        op_kwargs={"checkName": check_name, "resourceIdentifier": resource_identifier},
    )


async def list_all(
    hub,
    ctx,
    check_name: str = None,
    resource_identifier: Dict = None,
    ascending_order: bool = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Lists your Device Defender audit listings.

    Args:
        check_name(str, optional): An audit check name. Checks must be enabled for your account. (Use DescribeAccountAuditConfiguration to see the list of all checks, including those that are enabled or use UpdateAccountAuditConfiguration to select which checks are enabled.). Defaults to None.
        resource_identifier(Dict, optional): Information that identifies the noncompliant resource. Defaults to None.
        ascending_order(bool, optional):  Determines whether suppressions are listed in ascending order by expiration date or not. If parameter isn't provided, ascendingOrder=true. . Defaults to None.
        next_token(str, optional):  The token for the next set of results. . Defaults to None.
        max_results(int, optional):  The maximum number of results to return at one time. The default is 25. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.audit.suppression.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.audit.suppression.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="list_audit_suppressions",
        op_kwargs={
            "checkName": check_name,
            "resourceIdentifier": resource_identifier,
            "ascendingOrder": ascending_order,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )


async def update(
    hub,
    ctx,
    check_name: str,
    resource_identifier: Dict,
    expiration_date: str = None,
    suppress_indefinitely: bool = None,
    description: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Updates a Device Defender audit suppression.

    Args:
        check_name(str): An audit check name. Checks must be enabled for your account. (Use DescribeAccountAuditConfiguration to see the list of all checks, including those that are enabled or use UpdateAccountAuditConfiguration to select which checks are enabled.).
        resource_identifier(Dict): Information that identifies the noncompliant resource.
        expiration_date(str, optional):  The expiration date (epoch timestamp in seconds) that you want the suppression to adhere to. . Defaults to None.
        suppress_indefinitely(bool, optional):  Indicates whether a suppression should exist indefinitely or not. . Defaults to None.
        description(str, optional):  The description of the audit suppression. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.audit.suppression.update(
                ctx, check_name=value, resource_identifier=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.audit.suppression.update check_name=value, resource_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="update_audit_suppression",
        op_kwargs={
            "checkName": check_name,
            "resourceIdentifier": resource_identifier,
            "expirationDate": expiration_date,
            "suppressIndefinitely": suppress_indefinitely,
            "description": description,
        },
    )
