"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def cancel(hub, ctx, task_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Cancels a mitigation action task that is in progress. If the task is not in progress, an InvalidRequestException occurs.

    Args:
        task_id(str): The unique identifier for the task that you want to cancel. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.audit.mitigation_action.task.cancel(ctx, task_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.audit.mitigation_action.task.cancel task_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="cancel_audit_mitigation_actions_task",
        op_kwargs={"taskId": task_id},
    )


async def describe(hub, ctx, task_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about an audit mitigation task that is used to apply mitigation actions to a set of audit findings. Properties include the actions being applied, the audit checks to which they're being applied, the task status, and aggregated task statistics.

    Args:
        task_id(str): The unique identifier for the audit mitigation task.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.audit.mitigation_action.task.describe(ctx, task_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.audit.mitigation_action.task.describe task_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="describe_audit_mitigation_actions_task",
        op_kwargs={"taskId": task_id},
    )


async def list_all(
    hub,
    ctx,
    start_time: str,
    end_time: str,
    audit_task_id: str = None,
    finding_id: str = None,
    task_status: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets a list of audit mitigation action tasks that match the specified filters.

    Args:
        audit_task_id(str, optional): Specify this filter to limit results to tasks that were applied to results for a specific audit. Defaults to None.
        finding_id(str, optional): Specify this filter to limit results to tasks that were applied to a specific audit finding. Defaults to None.
        task_status(str, optional): Specify this filter to limit results to tasks that are in a specific state. Defaults to None.
        max_results(int, optional): The maximum number of results to return at one time. The default is 25. Defaults to None.
        next_token(str, optional): The token for the next set of results. Defaults to None.
        start_time(str): Specify this filter to limit results to tasks that began on or after a specific date and time.
        end_time(str): Specify this filter to limit results to tasks that were completed or canceled on or before a specific date and time.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.audit.mitigation_action.task.list_all(
                ctx, start_time=value, end_time=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.audit.mitigation_action.task.list_all start_time=value, end_time=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="list_audit_mitigation_actions_tasks",
        op_kwargs={
            "auditTaskId": audit_task_id,
            "findingId": finding_id,
            "taskStatus": task_status,
            "maxResults": max_results,
            "nextToken": next_token,
            "startTime": start_time,
            "endTime": end_time,
        },
    )


async def start(
    hub,
    ctx,
    task_id: str,
    target: Dict,
    audit_check_to_actions_mapping: Dict,
    client_request_token: str,
) -> Dict:
    r"""
    **Autogenerated function**

    Starts a task that applies a set of mitigation actions to the specified target.

    Args:
        task_id(str): A unique identifier for the task. You can use this identifier to check the status of the task or to cancel it.
        target(Dict): Specifies the audit findings to which the mitigation actions are applied. You can apply them to a type of audit check, to all findings from an audit, or to a specific set of findings.
        audit_check_to_actions_mapping(Dict): For an audit check, specifies which mitigation actions to apply. Those actions must be defined in your AWS account.
        client_request_token(str): Each audit mitigation task must have a unique client request token. If you try to start a new task with the same token as a task that already exists, an exception occurs. If you omit this value, a unique client request token is generated automatically.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.audit.mitigation_action.task.start(
                ctx,
                task_id=value,
                target=value,
                audit_check_to_actions_mapping=value,
                client_request_token=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.audit.mitigation_action.task.start task_id=value, target=value, audit_check_to_actions_mapping=value, client_request_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="start_audit_mitigation_actions_task",
        op_kwargs={
            "taskId": task_id,
            "target": target,
            "auditCheckToActionsMapping": audit_check_to_actions_mapping,
            "clientRequestToken": client_request_token,
        },
    )
