"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    task_id: str,
    finding_id: str,
    action_status: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets the status of audit mitigation action tasks that were executed.

    Args:
        task_id(str): Specify this filter to limit results to actions for a specific audit mitigation actions task.
        action_status(str, optional): Specify this filter to limit results to those with a specific status. Defaults to None.
        finding_id(str): Specify this filter to limit results to those that were applied to a specific audit finding.
        max_results(int, optional): The maximum number of results to return at one time. The default is 25. Defaults to None.
        next_token(str, optional): The token for the next set of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.audit.mitigation_action.execution.list_all(
                ctx, task_id=value, finding_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.audit.mitigation_action.execution.list_all task_id=value, finding_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="list_audit_mitigation_actions_executions",
        op_kwargs={
            "taskId": task_id,
            "actionStatus": action_status,
            "findingId": finding_id,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )
