"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, finding_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about a single audit finding. Properties include the reason for noncompliance, the severity of the issue, and the start time when the audit that returned the finding.

    Args:
        finding_id(str): A unique identifier for a single audit finding. You can use this identifier to apply mitigation actions to the finding.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.audit.finding.describe(ctx, finding_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.audit.finding.describe finding_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="describe_audit_finding",
        op_kwargs={"findingId": finding_id},
    )


async def list_all(
    hub,
    ctx,
    task_id: str = None,
    check_name: str = None,
    resource_identifier: Dict = None,
    max_results: int = None,
    next_token: str = None,
    start_time: str = None,
    end_time: str = None,
    list_suppressed_findings: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the findings (results) of a Device Defender audit or of the audits performed during a specified time period. (Findings are retained for 90 days.)

    Args:
        task_id(str, optional): A filter to limit results to the audit with the specified ID. You must specify either the taskId or the startTime and endTime, but not both. Defaults to None.
        check_name(str, optional): A filter to limit results to the findings for the specified audit check. Defaults to None.
        resource_identifier(Dict, optional): Information identifying the noncompliant resource. Defaults to None.
        max_results(int, optional): The maximum number of results to return at one time. The default is 25. Defaults to None.
        next_token(str, optional): The token for the next set of results. Defaults to None.
        start_time(str, optional): A filter to limit results to those found after the specified time. You must specify either the startTime and endTime or the taskId, but not both. Defaults to None.
        end_time(str, optional): A filter to limit results to those found before the specified time. You must specify either the startTime and endTime or the taskId, but not both. Defaults to None.
        list_suppressed_findings(bool, optional):  Boolean flag indicating whether only the suppressed findings or the unsuppressed findings should be listed. If this parameter isn't provided, the response will list both suppressed and unsuppressed findings. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.audit.finding.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.audit.finding.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="list_audit_findings",
        op_kwargs={
            "taskId": task_id,
            "checkName": check_name,
            "resourceIdentifier": resource_identifier,
            "maxResults": max_results,
            "nextToken": next_token,
            "startTime": start_time,
            "endTime": end_time,
            "listSuppressedFindings": list_suppressed_findings,
        },
    )
