"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    target: str,
    recursive: bool = None,
    marker: str = None,
    page_size: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the policies attached to the specified thing group.

    Args:
        target(str): The group or principal for which the policies will be listed. Valid principals are CertificateArn (arn:aws:iot:region:accountId:cert/certificateId), thingGroupArn (arn:aws:iot:region:accountId:thinggroup/groupName) and CognitoId (region:id).
        recursive(bool, optional): When true, recursively list attached policies. Defaults to None.
        marker(str, optional): The token to retrieve the next set of results. Defaults to None.
        page_size(int, optional): The maximum number of results to be returned per request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.attached_policy.list_all(ctx, target=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.attached_policy.list_all target=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="list_attached_policies",
        op_kwargs={
            "target": target,
            "recursive": recursive,
            "marker": marker,
            "pageSize": page_size,
        },
    )
