"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    thing_name: str = None,
    security_profile_name: str = None,
    behavior_criteria_type: str = None,
    list_suppressed_alerts: bool = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the active violations for a given Device Defender security profile.

    Args:
        thing_name(str, optional): The name of the thing whose active violations are listed. Defaults to None.
        security_profile_name(str, optional): The name of the Device Defender security profile for which violations are listed. Defaults to None.
        behavior_criteria_type(str, optional):  The criteria for a behavior. . Defaults to None.
        list_suppressed_alerts(bool, optional):  A list of all suppressed alerts. . Defaults to None.
        next_token(str, optional): The token for the next set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return at one time. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.active_violation.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.active_violation.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="list_active_violations",
        op_kwargs={
            "thingName": thing_name,
            "securityProfileName": security_profile_name,
            "behaviorCriteriaType": behavior_criteria_type,
            "listSuppressedAlerts": list_suppressed_alerts,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
