"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, delete_scheduled_audits: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Restores the default settings for Device Defender audits for this account. Any configuration data you entered is deleted and all audit checks are reset to disabled.

    Args:
        delete_scheduled_audits(bool, optional): If true, all scheduled audits are deleted. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.account_audit_configuration.delete(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.account_audit_configuration.delete
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="delete_account_audit_configuration",
        op_kwargs={"deleteScheduledAudits": delete_scheduled_audits},
    )


async def describe(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about the Device Defender audit settings for this account. Settings include how audit notifications are sent and which audit checks are enabled or disabled.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.account_audit_configuration.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.account_audit_configuration.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="describe_account_audit_configuration",
        op_kwargs={},
    )


async def update(
    hub,
    ctx,
    role_arn: str = None,
    audit_notification_target_configurations: Dict = None,
    audit_check_configurations: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Configures or reconfigures the Device Defender audit settings for this account. Settings include how audit notifications are sent and which audit checks are enabled or disabled.

    Args:
        role_arn(str, optional): The Amazon Resource Name (ARN) of the role that grants permission to AWS IoT to access information about your devices, policies, certificates, and other items as required when performing an audit. Defaults to None.
        audit_notification_target_configurations(Dict, optional): Information about the targets to which audit notifications are sent. Defaults to None.
        audit_check_configurations(Dict, optional): Specifies which audit checks are enabled and disabled for this account. Use DescribeAccountAuditConfiguration to see the list of all checks, including those that are currently enabled. Some data collection might start immediately when certain checks are enabled. When a check is disabled, any data collected so far in relation to the check is deleted. You cannot disable a check if it's used by any scheduled audit. You must first delete the check from the scheduled audit or delete the scheduled audit itself. On the first call to UpdateAccountAuditConfiguration, this parameter is required and must specify at least one enabled check. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.account_audit_configuration.update(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.account_audit_configuration.update
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="update_account_audit_configuration",
        op_kwargs={
            "roleArn": role_arn,
            "auditNotificationTargetConfigurations": audit_notification_target_configurations,
            "auditCheckConfigurations": audit_check_configurations,
        },
    )
