"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, assessment_run_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Information about the data that is collected for the specified assessment run.

    Args:
        assessment_run_arn(str): The ARN that specifies the assessment run that has the telemetry data that you want to obtain.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.inspector.telemetry_metadata.get(ctx, assessment_run_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.inspector.telemetry_metadata.get assessment_run_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="inspector",
        operation="get_telemetry_metadata",
        op_kwargs={"assessmentRunArn": assessment_run_arn},
    )
