"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__func_alias__ = {"list_": "list", "set_": "set"}


async def list_(hub, ctx, resource_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Lists all tags associated with an assessment template.

    Args:
        resource_arn(str): The ARN that specifies the assessment template whose tags you want to list.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.inspector.tags_for_resource.list(ctx, resource_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.inspector.tags_for_resource.list resource_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="inspector",
        operation="list_tags_for_resource",
        op_kwargs={"resourceArn": resource_arn},
    )


async def set_(hub, ctx, resource_arn: str, tags: List = None) -> None:
    r"""
    **Autogenerated function**

    Sets tags (key and value pairs) to the assessment template that is specified by the ARN of the assessment template.

    Args:
        resource_arn(str): The ARN of the assessment template that you want to set tags to.
        tags(List, optional): A collection of key and value pairs that you want to set to the assessment template. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.inspector.tags_for_resource.set(ctx, resource_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.inspector.tags_for_resource.set resource_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="inspector",
        operation="set_tags_for_resource",
        op_kwargs={"resourceArn": resource_arn, "tags": tags},
    )
