"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(hub, ctx, rules_package_arns: List, locale: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Describes the rules packages that are specified by the ARNs of the rules packages.

    Args:
        rules_package_arns(List): The ARN that specifies the rules package that you want to describe.
        locale(str, optional): The locale that you want to translate a rules package description into. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.inspector.rule_package.describe_all(
                ctx, rules_package_arns=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.inspector.rule_package.describe_all rules_package_arns=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="inspector",
        operation="describe_rules_packages",
        op_kwargs={"rulesPackageArns": rules_package_arns, "locale": locale},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists all available Amazon Inspector rules packages.

    Args:
        next_token(str, optional): You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the ListRulesPackages action. Subsequent calls to the action fill nextToken in the request with the value of NextToken from the previous response to continue listing data. Defaults to None.
        max_results(int, optional): You can use this parameter to indicate the maximum number of items you want in the response. The default value is 10. The maximum value is 500. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.inspector.rule_package.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.inspector.rule_package.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="inspector",
        operation="list_rules_packages",
        op_kwargs={"nextToken": next_token, "maxResults": max_results},
    )
