"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(hub, ctx, resource_group_tags: List) -> Dict:
    r"""
    **Autogenerated function**

    Creates a resource group using the specified set of tags (key and value pairs) that are used to select the EC2 instances to be included in an Amazon Inspector assessment target. The created resource group is then used to create an Amazon Inspector assessment target. For more information, see CreateAssessmentTarget.

    Args:
        resource_group_tags(List): A collection of keys and an array of possible values, '[{"key":"key1","values":["Value1","Value2"]},{"key":"Key2","values":["Value3"]}]'. For example,'[{"key":"Name","values":["TestEC2Instance"]}]'.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.inspector.resource_group.create(ctx, resource_group_tags=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.inspector.resource_group.create resource_group_tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="inspector",
        operation="create_resource_group",
        op_kwargs={"resourceGroupTags": resource_group_tags},
    )


async def describe_all(hub, ctx, resource_group_arns: List) -> Dict:
    r"""
    **Autogenerated function**

    Describes the resource groups that are specified by the ARNs of the resource groups.

    Args:
        resource_group_arns(List): The ARN that specifies the resource group that you want to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.inspector.resource_group.describe_all(
                ctx, resource_group_arns=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.inspector.resource_group.describe_all resource_group_arns=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="inspector",
        operation="describe_resource_groups",
        op_kwargs={"resourceGroupArns": resource_group_arns},
    )
