"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def unsubscribe(hub, ctx, resource_arn: str, event: str, topic_arn: str) -> None:
    r"""
    **Autogenerated function**

    Disables the process of sending Amazon Simple Notification Service (SNS) notifications about a specified event to a specified SNS topic.

    Args:
        resource_arn(str): The ARN of the assessment template that is used during the event for which you want to stop receiving SNS notifications.
        event(str): The event for which you want to stop receiving SNS notifications.
        topic_arn(str): The ARN of the SNS topic to which SNS notifications are sent.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.inspector.from_event.unsubscribe(
                ctx, resource_arn=value, event=value, topic_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.inspector.from_event.unsubscribe resource_arn=value, event=value, topic_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="inspector",
        operation="unsubscribe_from_event",
        op_kwargs={"resourceArn": resource_arn, "event": event, "topicArn": topic_arn},
    )
