"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(hub, ctx, finding_arns: List, locale: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Describes the findings that are specified by the ARNs of the findings.

    Args:
        finding_arns(List): The ARN that specifies the finding that you want to describe.
        locale(str, optional): The locale into which you want to translate a finding description, recommendation, and the short description that identifies the finding. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.inspector.finding.describe_all(ctx, finding_arns=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.inspector.finding.describe_all finding_arns=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="inspector",
        operation="describe_findings",
        op_kwargs={"findingArns": finding_arns, "locale": locale},
    )


async def list_all(
    hub,
    ctx,
    assessment_run_arns: List = None,
    filter_: Dict = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists findings that are generated by the assessment runs that are specified by the ARNs of the assessment runs.

    Args:
        assessment_run_arns(List, optional): The ARNs of the assessment runs that generate the findings that you want to list. Defaults to None.
        filter_(Dict, optional): You can use this parameter to specify a subset of data to be included in the action's response. For a record to match a filter, all specified filter attributes must match. When multiple values are specified for a filter attribute, any of the values can match. Defaults to None.
        next_token(str, optional): You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the ListFindings action. Subsequent calls to the action fill nextToken in the request with the value of NextToken from the previous response to continue listing data. Defaults to None.
        max_results(int, optional): You can use this parameter to indicate the maximum number of items you want in the response. The default value is 10. The maximum value is 500. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.inspector.finding.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.inspector.finding.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="inspector",
        operation="list_findings",
        op_kwargs={
            "assessmentRunArns": assessment_run_arns,
            "filter": filter_,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
