"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, assessment_template_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Starts the generation of an exclusions preview for the specified assessment template. The exclusions preview lists the potential exclusions (ExclusionPreview) that Inspector can detect before it runs the assessment.

    Args:
        assessment_template_arn(str): The ARN that specifies the assessment template for which you want to create an exclusions preview.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.inspector.exclusion.preview.create(
                ctx, assessment_template_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.inspector.exclusion.preview.create assessment_template_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="inspector",
        operation="create_exclusions_preview",
        op_kwargs={"assessmentTemplateArn": assessment_template_arn},
    )


async def get(
    hub,
    ctx,
    assessment_template_arn: str,
    preview_token: str,
    next_token: str = None,
    max_results: int = None,
    locale: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the exclusions preview (a list of ExclusionPreview objects) specified by the preview token. You can obtain the preview token by running the CreateExclusionsPreview API.

    Args:
        assessment_template_arn(str): The ARN that specifies the assessment template for which the exclusions preview was requested.
        preview_token(str): The unique identifier associated of the exclusions preview.
        next_token(str, optional): You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the GetExclusionsPreviewRequest action. Subsequent calls to the action fill nextToken in the request with the value of nextToken from the previous response to continue listing data. Defaults to None.
        max_results(int, optional): You can use this parameter to indicate the maximum number of items you want in the response. The default value is 100. The maximum value is 500. Defaults to None.
        locale(str, optional): The locale into which you want to translate the exclusion's title, description, and recommendation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.inspector.exclusion.preview.get(
                ctx, assessment_template_arn=value, preview_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.inspector.exclusion.preview.get assessment_template_arn=value, preview_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="inspector",
        operation="get_exclusions_preview",
        op_kwargs={
            "assessmentTemplateArn": assessment_template_arn,
            "previewToken": preview_token,
            "nextToken": next_token,
            "maxResults": max_results,
            "locale": locale,
        },
    )
