"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(hub, ctx, exclusion_arns: List, locale: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Describes the exclusions that are specified by the exclusions' ARNs.

    Args:
        exclusion_arns(List): The list of ARNs that specify the exclusions that you want to describe.
        locale(str, optional): The locale into which you want to translate the exclusion's title, description, and recommendation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.inspector.exclusion.init.describe_all(ctx, exclusion_arns=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.inspector.exclusion.init.describe_all exclusion_arns=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="inspector",
        operation="describe_exclusions",
        op_kwargs={"exclusionArns": exclusion_arns, "locale": locale},
    )


async def list_all(
    hub, ctx, assessment_run_arn: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    List exclusions that are generated by the assessment run.

    Args:
        assessment_run_arn(str): The ARN of the assessment run that generated the exclusions that you want to list.
        next_token(str, optional): You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the ListExclusionsRequest action. Subsequent calls to the action fill nextToken in the request with the value of nextToken from the previous response to continue listing data. Defaults to None.
        max_results(int, optional): You can use this parameter to indicate the maximum number of items you want in the response. The default value is 100. The maximum value is 500. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.inspector.exclusion.init.list_all(ctx, assessment_run_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.inspector.exclusion.init.list_all assessment_run_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="inspector",
        operation="list_exclusions",
        op_kwargs={
            "assessmentRunArn": assessment_run_arn,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
