"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub, ctx, resource_arn: str = None, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all the event subscriptions for the assessment template that is specified by the ARN of the assessment template. For more information, see SubscribeToEvent and UnsubscribeFromEvent.

    Args:
        resource_arn(str, optional): The ARN of the assessment template for which you want to list the existing event subscriptions. Defaults to None.
        next_token(str, optional): You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the ListEventSubscriptions action. Subsequent calls to the action fill nextToken in the request with the value of NextToken from the previous response to continue listing data. Defaults to None.
        max_results(int, optional): You can use this parameter to indicate the maximum number of items you want in the response. The default value is 10. The maximum value is 500. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.inspector.event_subscription.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.inspector.event_subscription.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="inspector",
        operation="list_event_subscriptions",
        op_kwargs={
            "resourceArn": resource_arn,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
