"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Describes the IAM role that enables Amazon Inspector to access your AWS account.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.inspector.cross_account_access_role.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.inspector.cross_account_access_role.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="inspector",
        operation="describe_cross_account_access_role",
        op_kwargs={},
    )


async def register(hub, ctx, role_arn: str) -> None:
    r"""
    **Autogenerated function**

    Registers the IAM role that grants Amazon Inspector access to AWS Services needed to perform security assessments.

    Args:
        role_arn(str): The ARN of the IAM role that grants Amazon Inspector access to AWS Services needed to perform security assessments. .
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.inspector.cross_account_access_role.register(
                ctx, role_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.inspector.cross_account_access_role.register role_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="inspector",
        operation="register_cross_account_access_role",
        op_kwargs={"roleArn": role_arn},
    )
