"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def add(hub, ctx, finding_arns: List, attributes: List) -> Dict:
    r"""
    **Autogenerated function**

    Assigns attributes (key and value pairs) to the findings that are specified by the ARNs of the findings.

    Args:
        finding_arns(List): The ARNs that specify the findings that you want to assign attributes to.
        attributes(List): The array of attributes that you want to assign to specified findings.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.inspector.attribute.to_finding.add(
                ctx, finding_arns=value, attributes=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.inspector.attribute.to_finding.add finding_arns=value, attributes=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="inspector",
        operation="add_attributes_to_findings",
        op_kwargs={"findingArns": finding_arns, "attributes": attributes},
    )
