"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def remove(hub, ctx, finding_arns: List, attribute_keys: List) -> Dict:
    r"""
    **Autogenerated function**

    Removes entire attributes (key and value pairs) from the findings that are specified by the ARNs of the findings where an attribute with the specified key exists.

    Args:
        finding_arns(List): The ARNs that specify the findings that you want to remove attributes from.
        attribute_keys(List): The array of attribute keys that you want to remove from specified findings.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.inspector.attribute.from_finding.remove(
                ctx, finding_arns=value, attribute_keys=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.inspector.attribute.from_finding.remove finding_arns=value, attribute_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="inspector",
        operation="remove_attributes_from_findings",
        op_kwargs={"findingArns": finding_arns, "attributeKeys": attribute_keys},
    )
