"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    assessment_target_arn: str,
    assessment_template_name: str,
    duration_in_seconds: int,
    rules_package_arns: List,
    user_attributes_for_findings: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an assessment template for the assessment target that is specified by the ARN of the assessment target. If the service-linked role isn’t already registered, this action also creates and registers a service-linked role to grant Amazon Inspector access to AWS Services needed to perform security assessments.

    Args:
        assessment_target_arn(str): The ARN that specifies the assessment target for which you want to create the assessment template.
        assessment_template_name(str): The user-defined name that identifies the assessment template that you want to create. You can create several assessment templates for an assessment target. The names of the assessment templates that correspond to a particular assessment target must be unique.
        duration_in_seconds(int): The duration of the assessment run in seconds.
        rules_package_arns(List): The ARNs that specify the rules packages that you want to attach to the assessment template.
        user_attributes_for_findings(List, optional): The user-defined attributes that are assigned to every finding that is generated by the assessment run that uses this assessment template. An attribute is a key and value pair (an Attribute object). Within an assessment template, each key must be unique. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.inspector.assessment.template.create(
                ctx,
                assessment_target_arn=value,
                assessment_template_name=value,
                duration_in_seconds=value,
                rules_package_arns=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.inspector.assessment.template.create assessment_target_arn=value, assessment_template_name=value, duration_in_seconds=value, rules_package_arns=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="inspector",
        operation="create_assessment_template",
        op_kwargs={
            "assessmentTargetArn": assessment_target_arn,
            "assessmentTemplateName": assessment_template_name,
            "durationInSeconds": duration_in_seconds,
            "rulesPackageArns": rules_package_arns,
            "userAttributesForFindings": user_attributes_for_findings,
        },
    )


async def delete(hub, ctx, assessment_template_arn: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the assessment template that is specified by the ARN of the assessment template.

    Args:
        assessment_template_arn(str): The ARN that specifies the assessment template that you want to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.inspector.assessment.template.delete(
                ctx, assessment_template_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.inspector.assessment.template.delete assessment_template_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="inspector",
        operation="delete_assessment_template",
        op_kwargs={"assessmentTemplateArn": assessment_template_arn},
    )


async def describe_all(hub, ctx, assessment_template_arns: List) -> Dict:
    r"""
    **Autogenerated function**

    Describes the assessment templates that are specified by the ARNs of the assessment templates.

    Args:
        assessment_template_arns(List): .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.inspector.assessment.template.describe_all(
                ctx, assessment_template_arns=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.inspector.assessment.template.describe_all assessment_template_arns=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="inspector",
        operation="describe_assessment_templates",
        op_kwargs={"assessmentTemplateArns": assessment_template_arns},
    )


async def list_all(
    hub,
    ctx,
    assessment_target_arns: List = None,
    filter_: Dict = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the assessment templates that correspond to the assessment targets that are specified by the ARNs of the assessment targets.

    Args:
        assessment_target_arns(List, optional): A list of ARNs that specifies the assessment targets whose assessment templates you want to list. Defaults to None.
        filter_(Dict, optional): You can use this parameter to specify a subset of data to be included in the action's response. For a record to match a filter, all specified filter attributes must match. When multiple values are specified for a filter attribute, any of the values can match. Defaults to None.
        next_token(str, optional): You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the ListAssessmentTemplates action. Subsequent calls to the action fill nextToken in the request with the value of NextToken from the previous response to continue listing data. Defaults to None.
        max_results(int, optional): You can use this parameter to indicate the maximum number of items you want in the response. The default value is 10. The maximum value is 500. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.inspector.assessment.template.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.inspector.assessment.template.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="inspector",
        operation="list_assessment_templates",
        op_kwargs={
            "assessmentTargetArns": assessment_target_arns,
            "filter": filter_,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
