"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub, ctx, assessment_target_name: str, resource_group_arn: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new assessment target using the ARN of the resource group that is generated by CreateResourceGroup. If resourceGroupArn is not specified, all EC2 instances in the current AWS account and region are included in the assessment target. If the service-linked role isn’t already registered, this action also creates and registers a service-linked role to grant Amazon Inspector access to AWS Services needed to perform security assessments. You can create up to 50 assessment targets per AWS account. You can run up to 500 concurrent agents per AWS account. For more information, see  Amazon Inspector Assessment Targets.

    Args:
        assessment_target_name(str): The user-defined name that identifies the assessment target that you want to create. The name must be unique within the AWS account.
        resource_group_arn(str, optional): The ARN that specifies the resource group that is used to create the assessment target. If resourceGroupArn is not specified, all EC2 instances in the current AWS account and region are included in the assessment target. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.inspector.assessment.target.create(
                ctx, assessment_target_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.inspector.assessment.target.create assessment_target_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="inspector",
        operation="create_assessment_target",
        op_kwargs={
            "assessmentTargetName": assessment_target_name,
            "resourceGroupArn": resource_group_arn,
        },
    )


async def delete(hub, ctx, assessment_target_arn: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the assessment target that is specified by the ARN of the assessment target.

    Args:
        assessment_target_arn(str): The ARN that specifies the assessment target that you want to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.inspector.assessment.target.delete(
                ctx, assessment_target_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.inspector.assessment.target.delete assessment_target_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="inspector",
        operation="delete_assessment_target",
        op_kwargs={"assessmentTargetArn": assessment_target_arn},
    )


async def describe_all(hub, ctx, assessment_target_arns: List) -> Dict:
    r"""
    **Autogenerated function**

    Describes the assessment targets that are specified by the ARNs of the assessment targets.

    Args:
        assessment_target_arns(List): The ARNs that specifies the assessment targets that you want to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.inspector.assessment.target.describe_all(
                ctx, assessment_target_arns=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.inspector.assessment.target.describe_all assessment_target_arns=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="inspector",
        operation="describe_assessment_targets",
        op_kwargs={"assessmentTargetArns": assessment_target_arns},
    )


async def list_all(
    hub, ctx, filter_: Dict = None, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the ARNs of the assessment targets within this AWS account. For more information about assessment targets, see Amazon Inspector Assessment Targets.

    Args:
        filter_(Dict, optional): You can use this parameter to specify a subset of data to be included in the action's response. For a record to match a filter, all specified filter attributes must match. When multiple values are specified for a filter attribute, any of the values can match. Defaults to None.
        next_token(str, optional): You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the ListAssessmentTargets action. Subsequent calls to the action fill nextToken in the request with the value of NextToken from the previous response to continue listing data. Defaults to None.
        max_results(int, optional): You can use this parameter to indicate the maximum number of items you want in the response. The default value is 10. The maximum value is 500. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.inspector.assessment.target.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.inspector.assessment.target.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="inspector",
        operation="list_assessment_targets",
        op_kwargs={
            "filter": filter_,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )


async def update(
    hub,
    ctx,
    assessment_target_arn: str,
    assessment_target_name: str,
    resource_group_arn: str = None,
) -> None:
    r"""
    **Autogenerated function**

    Updates the assessment target that is specified by the ARN of the assessment target. If resourceGroupArn is not specified, all EC2 instances in the current AWS account and region are included in the assessment target.

    Args:
        assessment_target_arn(str): The ARN of the assessment target that you want to update.
        assessment_target_name(str): The name of the assessment target that you want to update.
        resource_group_arn(str, optional): The ARN of the resource group that is used to specify the new resource group to associate with the assessment target. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.inspector.assessment.target.update(
                ctx, assessment_target_arn=value, assessment_target_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.inspector.assessment.target.update assessment_target_arn=value, assessment_target_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="inspector",
        operation="update_assessment_target",
        op_kwargs={
            "assessmentTargetArn": assessment_target_arn,
            "assessmentTargetName": assessment_target_name,
            "resourceGroupArn": resource_group_arn,
        },
    )
