"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub, ctx, assessment_run_arn: str, report_file_format: str, report_type: str
) -> Dict:
    r"""
    **Autogenerated function**

    Produces an assessment report that includes detailed and comprehensive results of a specified assessment run.

    Args:
        assessment_run_arn(str): The ARN that specifies the assessment run for which you want to generate a report.
        report_file_format(str): Specifies the file format (html or pdf) of the assessment report that you want to generate.
        report_type(str): Specifies the type of the assessment report that you want to generate. There are two types of assessment reports: a finding report and a full report. For more information, see Assessment Reports. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.inspector.assessment.report.get(
                ctx, assessment_run_arn=value, report_file_format=value, report_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.inspector.assessment.report.get assessment_run_arn=value, report_file_format=value, report_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="inspector",
        operation="get_assessment_report",
        op_kwargs={
            "assessmentRunArn": assessment_run_arn,
            "reportFileFormat": report_file_format,
            "reportType": report_type,
        },
    )
